﻿//////////////////////////////////////////////
// DdsHeaderFlag.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Class ------------------------------------

namespace nkImages::dds
{
	enum class DDS_HEADER_FLAG : unsigned int
	{
		DDS_HEADER_FLAG_UNKNOWN = 0,
		DDSD_CAPS = 0x1,
		DDSD_HEIGHT = 0x2,
		DDSD_WIDTH = 0x4,
		DDSD_PITCH = 0x8,
		DDSD_PIXELFORMAT = 0x1000,
		DDSD_MIPMAPCOUNT = 0x20000,
		DDSD_LINEARSIZE = 0x80000,
		DDSD_DEPTH = 0x800000
	} ;

	inline DDS_HEADER_FLAG operator& (DDS_HEADER_FLAG a, DDS_HEADER_FLAG b)
	{
		return (DDS_HEADER_FLAG)((unsigned int)a & (unsigned int)b) ;
	}

	inline DDS_HEADER_FLAG operator| (DDS_HEADER_FLAG a, DDS_HEADER_FLAG b)
	{
		return (DDS_HEADER_FLAG)((unsigned int)a | (unsigned int)b) ;
	}
}